<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:px="http://www.publishingx.de/" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
	
	<xsl:output indent="yes"></xsl:output>

	<xsl:param name="pageWidth" select="px:mm2pt(210)"/> 
	<xsl:param name="pageHeight" select="px:mm2pt(297)"/> 
	<xsl:param name="pageBinding" select="0.5"/> <!--Seitenindex der Bindung 0,5 bei Einzelseiten -->
	<xsl:variable name="pageNum" select="0"/>  <!-- Seitenindex der Seite -->

	<xsl:template match="data">
		<xsl:message select="$pageHeight"></xsl:message>
		<xsl:processing-instruction name="aid">style="50" type="snippet" readerVersion="6.0" featureSet="257" product="11.1(122)"</xsl:processing-instruction>
		<xsl:processing-instruction name="aid">SnippetType="PageItem"</xsl:processing-instruction>
		<Document DOMVersion="11.0" Self="d_{generate-id()}">
			<Spread Self="sp_{generate-id()}">
				<xsl:apply-templates select="page/rect"/>
			</Spread>
		</Document>
	</xsl:template>

	<xsl:template match="rect">
		<xsl:variable name="left" select="px:mm2pt(@left)"/>
		<xsl:variable name="top" select="px:mm2pt(@top)"/>
		<xsl:variable name="right" select="px:mm2pt(@left + @width)"/>
		<xsl:variable name="bottom" select="px:mm2pt(@top + @height)"/>
		
		<xsl:variable name="pageXTranslation" select="($pageNum - $pageBinding) * $pageWidth"/> 
		<xsl:variable name="pageYTranslation" select="($pageHeight div 2) * -1"/>
		
		<Rectangle StrokeWeight="0" StrokeColor="Swatch/None" ItemTransform="1 0 0 1 {$pageXTranslation} {$pageYTranslation}" Self="rect_{generate-id()}">
			<Properties>
				<PathGeometry>
					<GeometryPathType PathOpen="false">
						<PathPointArray>
							<PathPointType Anchor="{$left} {$top}" LeftDirection="{$left} {$top}"
								RightDirection="{$left} {$top}"/>
							<PathPointType Anchor="{$left} {$bottom}" LeftDirection="{$left} {$bottom}"
								RightDirection="{$left} {$bottom}"/>
							<PathPointType Anchor="{$right} {$bottom}"
								LeftDirection="{$right} {$bottom}"
								RightDirection="{$right} {$bottom}"/>
							<PathPointType Anchor="{$right} {$top}" LeftDirection="{$right} {$top}"
								RightDirection="{$right} {$top}"/>
						</PathPointArray>
					</GeometryPathType>
				</PathGeometry>
			</Properties>
		</Rectangle>
	</xsl:template>
	
	<xsl:function name="px:mm2pt">
		<xsl:param name="value" as="xs:double"/>
		<xsl:value-of select="($value div 25.4 ) * 72"/>
	</xsl:function>
	
</xsl:stylesheet>
