<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:px="http://www.publishingx.de/" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="xs" version="2.0">

	<xsl:output indent="yes"/>

	<xsl:param name="pageWidth" select="px:mm2pt(210)"/> 
	<xsl:param name="pageHeight" select="px:mm2pt(297)"/> 
	<xsl:param name="pageBinding" select="0.5"/> <!--Seitenindex der Bindung 0,5 bei Einzelseiten -->
	<xsl:variable name="pageNum" select="0"/>  <!-- Seitenindex der Seite -->

	<xsl:template match="data">
		<xsl:message select="$pageHeight"/>
		<xsl:processing-instruction name="aid">style="50" type="snippet" readerVersion="6.0" featureSet="257" product="11.1(122)"</xsl:processing-instruction>
		<xsl:processing-instruction name="aid">SnippetType="PageItem"</xsl:processing-instruction>
		<Document DOMVersion="11.0" Self="d_{generate-id()}">
			<RootCharacterStyleGroup Self="rcg_{generate-id()}">
				<xsl:for-each-group select="//span" group-by="@class">
					<xsl:apply-templates select="@class"/>
				</xsl:for-each-group>
			</RootCharacterStyleGroup>
			<RootParagraphStyleGroup Self="rpg_{generate-id()}">
				<ParagraphStyle Self="ParagraphStyle/$ID/NormalParagraphStyle"
					Name="$ID/NormalParagraphStyle"/>
				<xsl:for-each-group select="//p" group-by="@class">
					<xsl:apply-templates select="@class"/>
				</xsl:for-each-group>
			</RootParagraphStyleGroup>
			<RootCellStyleGroup Self="u69">
				<CellStyle Self="CellStyle/$ID/[None]" Name="$ID/[None]"/>
				<CellStyle Self="CellStyle/kopf" Name="kopf"/>
				<CellStyle Self="CellStyle/fuss" Name="fuss"/>
				<CellStyle Self="CellStyle/body" Name="body"/>
				<CellStyle Self="CellStyle/erste" Name="erste"/>
			</RootCellStyleGroup>
			<RootTableStyleGroup Self="u6b">
				<TableStyle Self="TableStyle/tabelle" Name="tabelle"/>
			</RootTableStyleGroup>

			<Spread Self="sp_{generate-id()}">
				<xsl:apply-templates select="page/text" mode="frame"/>
			</Spread>
			<xsl:apply-templates select="page/text" mode="story"/>
		</Document>
	</xsl:template>

	<xsl:template match="text" mode="frame">
		<xsl:variable name="left" select="px:mm2pt(@left)"/>
		<xsl:variable name="top" select="px:mm2pt(@top)"/>
		<xsl:variable name="right" select="px:mm2pt(@left + @width)"/>
		<xsl:variable name="bottom" select="px:mm2pt(@top + @height)"/>

		<xsl:variable name="pageXTranslation" select="($pageNum - $pageBinding) * $pageWidth"/> 
		<xsl:variable name="pageYTranslation" select="($pageHeight div 2) * -1"/>

		<TextFrame StrokeWeight="0" StrokeColor="Swatch/None"
			ItemTransform="1 0 0 1 {$pageXTranslation} {$pageYTranslation}"
			Self="rect_{generate-id()}" ParentStory="story_{generate-id()}">
			<Properties>
				<PathGeometry>
					<GeometryPathType PathOpen="false">
						<PathPointArray>
							<PathPointType Anchor="{$left} {$top}" LeftDirection="{$left} {$top}"
								RightDirection="{$left} {$top}"/>
							<PathPointType Anchor="{$left} {$bottom}"
								LeftDirection="{$left} {$bottom}" RightDirection="{$left} {$bottom}"/>
							<PathPointType Anchor="{$right} {$bottom}"
								LeftDirection="{$right} {$bottom}"
								RightDirection="{$right} {$bottom}"/>
							<PathPointType Anchor="{$right} {$top}" LeftDirection="{$right} {$top}"
								RightDirection="{$right} {$top}"/>
						</PathPointArray>
					</GeometryPathType>
				</PathGeometry>
			</Properties>
		</TextFrame>

	</xsl:template>

	<xsl:template match="text" mode="story">
		<Story Self="story_{generate-id()}">
			<xsl:apply-templates/>
		</Story>
	</xsl:template>

	<xsl:template match="p">
		<ParagraphStyleRange>
			<xsl:attribute name="AppliedParagraphStyle">
				<xsl:text>ParagraphStyle/</xsl:text>
				<xsl:choose>
					<xsl:when test="@class">
						<xsl:value-of select="@class"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>$ID/NormalParagraphStyle</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="text() | *" mode="cStyleRange"/>
			<Br/>
		</ParagraphStyleRange>
	</xsl:template>

	<xsl:template match="span" mode="cStyleRange">
		<CharacterStyleRange>
			<xsl:attribute name="AppliedCharacterStyle">
				<xsl:text>CharacterStyle/</xsl:text>
				<xsl:value-of select="@class"/>
			</xsl:attribute>
			<Content>
				<xsl:value-of select="."/>
			</Content>
		</CharacterStyleRange>
	</xsl:template>

	<xsl:template match="text()" mode="cStyleRange">
		<CharacterStyleRange>
			<xsl:attribute name="AppliedCharacterStyle">
				<xsl:text>CharacterStyle/$ID/[No character style]</xsl:text>
			</xsl:attribute>
			<Content>
				<xsl:value-of select="."/>
			</Content>
		</CharacterStyleRange>
	</xsl:template>


	<!--Erstellen von Formaten -->
	<xsl:template match="p/@class">
		<ParagraphStyle>
			<xsl:attribute name="Self">
				<xsl:text>ParagraphStyle/</xsl:text>
				<xsl:value-of select="."/>
			</xsl:attribute>
			<xsl:attribute name="Name">
				<xsl:value-of select="."/>
			</xsl:attribute>
		</ParagraphStyle>
	</xsl:template>
	<xsl:template match="span/@class">
		<CharacterStyle>
			<xsl:attribute name="Self">
				<xsl:text>CharacterStyle/</xsl:text>
				<xsl:value-of select="."/>
			</xsl:attribute>
			<xsl:attribute name="Name">
				<xsl:value-of select="."/>
			</xsl:attribute>
		</CharacterStyle>
	</xsl:template>


	<xsl:template match="table">
		<ParagraphStyleRange AppliedParagraphStyle="ParagraphStyle/$ID/NormalParagraphStyle">
			<CharacterStyleRange AppliedCharacterStyle="CharacterStyle/$ID/[No character style]">

				<Table Self="tb_{generate-id()}" HeaderRowCount="0" FooterRowCount="0"
					AppliedTableStyle="TableStyle/tabelle"
					TableDirection="LeftToRightDirection">
					<xsl:attribute name="BodyRowCount">
						<xsl:value-of select="count(.//tr)"/>
					</xsl:attribute>
					<xsl:variable name="maxCol">
						<xsl:for-each select=".//tr">
							<xsl:sort select="count(td)" order="descending"/>
							<xsl:if test="position() = 1">
								<xsl:copy-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:attribute name="ColumnCount">
						<xsl:value-of select="count($maxCol/tr/td)"/>
					</xsl:attribute>
					<xsl:variable name="columnWidth"
						select="px:mm2pt(parent::text/@width div count($maxCol/tr/td))"/>


					<xsl:for-each select="$maxCol/tr/td">
						<Column Self="" Name="{position() - 1}" SingleColumnWidth="{$columnWidth}"/>
					</xsl:for-each>



					<xsl:for-each select=".//tr">
						<xsl:variable name="rowNum" select="position() - 1"/>
						<xsl:for-each select="td">
							<xsl:variable name="colNum" select="position() - 1"/>
							<Cell Self="utd1c{$colNum}r{$rowNum}" Name="{$colNum}:{$rowNum}"
								RowSpan="1" ColumnSpan="1" AppliedCellStyle="CellStyle/$ID/[None]"
								AppliedCellStylePriority="0">
								<xsl:apply-templates/>
							</Cell>
						</xsl:for-each>
					</xsl:for-each>
				</Table>
			</CharacterStyleRange>
			<Br/>
		</ParagraphStyleRange>
	</xsl:template>

	<xsl:function name="px:mm2pt">
		<xsl:param name="value" as="xs:double"/>
		<xsl:value-of select="($value div 25.4) * 72"/>
	</xsl:function>

</xsl:stylesheet>
